import { system, world } from "@minecraft/server"
const cages = [
    'sf_nba:black_cage',
    'sf_nba:blue_cage',
    'sf_nba:brown_cage',
    'sf_nba:copper_cage',
    'sf_nba:cyan_cage',
    'sf_nba:glow_cage',
    'sf_nba:gray_cage',
    'sf_nba:green_cage',
    'sf_nba:light_blue_cage',
    'sf_nba:light_gray_cage',
    'sf_nba:lime_cage',
    'sf_nba:magenta_cage',
    'sf_nba:orange_cage',
    'sf_nba:pink_cage',
    'sf_nba:purple_cage',
    'sf_nba:red_cage',
    'sf_nba:white_cage',
    'sf_nba:yellow_cage'
]
const plushies = [
    'sf_nba:bear_plush',
    'sf_nba:hamster_plush',
    'sf_nba:lion_plush',
    'sf_nba:penguin_plush',
    'sf_nba:shark_plush'
]
const wheels = [
    'sf_nba:black_hamster_wheel',
    'sf_nba:blue_hamster_wheel',
    'sf_nba:brown_hamster_wheel',
    'sf_nba:copper_hamster_wheel',
    'sf_nba:cyan_hamster_wheel',
    'sf_nba:glow_hamster_wheel',
    'sf_nba:gray_hamster_wheel',
    'sf_nba:green_hamster_wheel',
    'sf_nba:light_blue_hamster_wheel',
    'sf_nba:light_gray_hamster_wheel',
    'sf_nba:lime_hamster_wheel',
    'sf_nba:magenta_hamster_wheel',
    'sf_nba:orange_hamster_wheel',
    'sf_nba:pink_hamster_wheel',
    'sf_nba:purple_hamster_wheel',
    'sf_nba:red_hamster_wheel',
    'sf_nba:white_hamster_wheel',
    'sf_nba:yellow_hamster_wheel'
]
const butterflies = [
    'sf_nba:butterfly_blue_morpho',
    'sf_nba:butterfly_cabbage_white',
    'sf_nba:butterfly_clouded_yellow',
    'sf_nba:butterfly_monarch',
    'sf_nba:butterfly_swallowtail'
]
const dragonflies = [
    'sf_nba:dragonfly_blue',
    'sf_nba:dragonfly_green',
    'sf_nba:dragonfly_red'
]
const treeFrogs = [
    'sf_nba:tree_frog_blue_dart',
    'sf_nba:tree_frog_green',
    'sf_nba:tree_frog_red_dart',
    'sf_nba:tree_frog_red_eyed',
    'sf_nba:tree_frog_strawberry_dart',
    'sf_nba:tree_frog_white',
    'sf_nba:tree_frog_yellow_dart'
]
const others = {
    'sf_nba:bee': 'minecraft:entity_spawned',
    'sf_nba:adult_bee': 'minecraft:spawn_adult',
    'sf_nba:baby_bee': 'minecraft:entity_born',
    'sf_nba:caterpillar': 'sf_nba:random_caterpillar_age',
    'sf_nba:caterpillar_adult': 'minecraft:entity_spawned',
    'sf_nba:caterpillar': 'sf_nba:random_caterpillar_age',
    'sf_nba:baby_desert_scorpion': 'sf_nba:scorpion_as_baby',
    'sf_nba:desert_scorpion': 'sf_nba:placed',
    'sf_nba:beetle_black': 'sf_nba:spawn_variant_4',
    'sf_nba:beetle_brown': 'sf_nba:spawn_variant_1',
    'sf_nba:beetle_green': 'sf_nba:spawn_variant_2',
    'sf_nba:beetle_red': 'sf_nba:spawn_variant_3',
    'sf_nba:beetle_white': 'sf_nba:spawn_variant_5',
    'sf_nba:beetle_yellow': 'sf_nba:spawn_variant_0',
    'sf_nba:endermite': 'minecraft:entity_spawned',
    'sf_nba:silverfish': 'minecraft:entity_spawned'
}
function getItemType(item) {
    if (cages.includes(item)) return 'cage'
    if (plushies.includes(item)) return 'plushy'
    if (wheels.includes(item)) return 'wheel'
    if (butterflies.includes(item)) return 'butterfly'
    if (dragonflies.includes(item)) return 'dragonfly'
    if (treeFrogs.includes(item)) return 'frog'
    if (Object.keys(others).includes(item)) return 'other'
}
function getSpawnEvent(item) {
    const removedNameSpace = () => item.split('sf_nba:')[1]
    const itemType = getItemType(item)
    const items = {
        cage: `${item.replace('cage', 'variant')}`,
        plushy: `sf_nba:spawn_${removedNameSpace(item).split('_plush')[0]}`,
        wheel: `${item.replace('hamster_wheel', 'variant')}`,
        butterfly: `${item.replace('butterfly', 'spawn')}`,
        dragonfly: `${item.replace('dragonfly', 'spawn')}`,
        frog: `${item.replace('tree_frog', 'placed')}`,
        other: others[item]
    }
    return items[itemType]
}
world.beforeEvents.itemUseOn.subscribe(e => {
    const { isFirstEvent, itemStack } = e
    if (![...cages, ...plushies, ...wheels, ...butterflies, ...dragonflies, ...treeFrogs, ...Object.keys(others)].includes(itemStack.typeId)) return
    if (!isFirstEvent) return
    system.run(() => {
        const eventToFire = getSpawnEvent(itemStack.typeId)
        const spawned = world.afterEvents.entitySpawn.subscribe(e => {
            e.entity.triggerEvent(eventToFire)
            world.afterEvents.entitySpawn.unsubscribe(spawned)
        })
    })
})